/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.forge;

import immersive_aircraft.ClientMain;
import immersive_aircraft.cobalt.network.NetworkHandler;
import immersive_aircraft.forge.cobalt.registration.RegistrationImpl;
import immersive_aircraft.item.upgrade.AircraftStat;
import immersive_aircraft.item.upgrade.AircraftUpgrade;
import immersive_aircraft.item.upgrade.AircraftUpgradeRegistry;
import immersive_aircraft.network.s2c.AircraftDataMessage;
import immersive_aircraft.network.s2c.AircraftUpgradesMessage;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="immersive_aircraft")
public class ForgeBusEvents {
    public static RegistrationImpl.DataLoaderRegister DATA_REGISTRY;
    public static RegistrationImpl.DataLoaderRegister RESOURCE_REGISTRY;
    private static final DecimalFormat fmt;
    public static boolean firstLoad;

    @SubscribeEvent
    public static void onClientStart(TickEvent.ClientTickEvent event) {
        if (firstLoad) {
            ClientMain.postLoad();
            firstLoad = false;
        }
        ClientMain.tick();
    }

    @SubscribeEvent
    public static void addReloadListenerEvent(AddReloadListenerEvent event) {
        if (DATA_REGISTRY != null) {
            for (PreparableReloadListener loader : DATA_REGISTRY.getLoaders()) {
                event.addListener(loader);
            }
        }
    }

    @SubscribeEvent
    public static void onDatapackSync(OnDatapackSyncEvent event) {
        if (event.getPlayer() != null) {
            NetworkHandler.sendToPlayer(new AircraftUpgradesMessage(), event.getPlayer());
            NetworkHandler.sendToPlayer(new AircraftDataMessage(), event.getPlayer());
        } else {
            for (ServerPlayer player : event.getPlayerList().m_11314_()) {
                NetworkHandler.sendToPlayer(new AircraftUpgradesMessage(), player);
                NetworkHandler.sendToPlayer(new AircraftDataMessage(), player);
            }
        }
    }

    @SubscribeEvent
    public static void onItemTooltips(ItemTooltipEvent event) {
        AircraftUpgrade upgrade = AircraftUpgradeRegistry.INSTANCE.getUpgrade(event.getItemStack().m_41720_());
        if (upgrade != null) {
            List tooltip = event.getToolTip();
            tooltip.add(Component.m_237115_((String)"item.immersive_aircraft.item.upgrade").m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
            for (Map.Entry<AircraftStat, Float> entry : upgrade.getAll().entrySet()) {
                tooltip.add(Component.m_237110_((String)("immersive_aircraft.upgrade." + entry.getKey().name().toLowerCase(Locale.ROOT)), (Object[])new Object[]{fmt.format(entry.getValue().floatValue() * 100.0f)}).m_130940_(entry.getValue().floatValue() * (float)(entry.getKey().positive() ? 1 : -1) > 0.0f ? ChatFormatting.GREEN : ChatFormatting.RED));
            }
        }
    }

    static {
        fmt = new DecimalFormat("+#;-#");
        firstLoad = true;
    }
}

